/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.advancements.predicate.CameraPredicate;
import io.github.mortuusars.exposure.advancements.predicate.FramePredicate;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import org.jetbrains.annotations.NotNull;

public class FrameExposedTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, CameraHolder cameraHolder, class_1799 cameraStack, Frame frame, List<class_2338> locationsInFrame, List<class_1309> entitiesInFrame) {
        this.method_22510(player, triggerInstance -> triggerInstance.matches(player, cameraHolder, cameraStack, frame, locationsInFrame, entitiesInFrame));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<CameraPredicate> camera;
        private final Optional<FramePredicate> frame;
        private final Optional<class_2090> locationInFrame;
        private final Optional<class_2048> entityInFrame;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)CameraPredicate.CODEC.optionalFieldOf("camera").forGetter(TriggerInstance::camera), (App)FramePredicate.CODEC.optionalFieldOf("frame").forGetter(TriggerInstance::frame), (App)class_2090.field_45760.optionalFieldOf("location_in_frame").forGetter(TriggerInstance::locationInFrame), (App)class_2048.field_45746.optionalFieldOf("entity_in_frame").forGetter(TriggerInstance::entityInFrame)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<CameraPredicate> camera, Optional<FramePredicate> frame, Optional<class_2090> locationInFrame, Optional<class_2048> entityInFrame) {
            this.player = player;
            this.camera = camera;
            this.frame = frame;
            this.locationInFrame = locationInFrame;
            this.entityInFrame = entityInFrame;
        }

        public boolean matches(class_3222 player, CameraHolder cameraHolder, class_1799 cameraStack, Frame frame, List<class_2338> locationsInFrame, List<class_1309> entitiesInFrame) {
            class_1297 holder = cameraHolder.asHolderEntity();
            return !(!this.camera.isEmpty() && !this.camera.get().matches(player.method_51469(), cameraStack, holder.method_19538()) || !this.frame.isEmpty() && !this.frame.get().matches(frame) || !this.locationInFrame.isEmpty() && !locationsInFrame.stream().anyMatch(pos -> this.locationInFrame.get().method_9018(player.method_51469(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)) || !this.entityInFrame.isEmpty() && !entitiesInFrame.stream().anyMatch(entity -> this.entityInFrame.get().method_8909(player.method_51469(), holder.method_19538(), (class_1297)entity)));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;camera;frame;locationInFrame;entityInFrame", "player", "camera", "frame", "locationInFrame", "entityInFrame"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;camera;frame;locationInFrame;entityInFrame", "player", "camera", "frame", "locationInFrame", "entityInFrame"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;camera;frame;locationInFrame;entityInFrame", "player", "camera", "frame", "locationInFrame", "entityInFrame"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<CameraPredicate> camera() {
            return this.camera;
        }

        public Optional<FramePredicate> frame() {
            return this.frame;
        }

        public Optional<class_2090> locationInFrame() {
            return this.locationInFrame;
        }

        public Optional<class_2048> entityInFrame() {
            return this.entityInFrame;
        }
    }
}

